/*
Collision Mask Utilities
Copyright ©2014 David Powell

Released under the MIT Licence

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QFileDialog>
#include <QMessageBox>
#include <QDesktopServices>
#include <QtEndian>
#include <QDragEnterEvent>
#include <QMimeData>
#include <QUrl>

namespace Ui {
class MainWindow;
}

/*!
 * \brief The MainWindow class
 */
class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    bool eventFilter(QObject *watched, QEvent *event);
    void dragEnterEvent(QDragEnterEvent *event);
    void dropEvent(QDropEvent *event);

private:
    void createMaskFile(QString imageFilename, QString maskFilename);
    QVarLengthArray<quint8> rleEncode(QVarLengthArray<quint8> pixels);
    quint32 calculateCrc32(QVarLengthArray<quint8> data, quint32 previousCrc32 = 0);

private slots:
    void on_actionExit_triggered();
    void on_actionAdd_triggered();
    void on_actionRemove_triggered();
    void on_actionClear_All_triggered();
    void on_actionGO_triggered();
    void on_actionAbout_triggered();
    void on_actionCheck_for_Updates_triggered();

private:
    Ui::MainWindow *ui;
};

#endif // MAINWINDOW_H
